// DirLightShader.fp
#version 100

precision highp float;

// Varyings
varying vec2 vTexCoord;
varying vec3 vNrm;

// Uniforms
uniform sampler2D colorMap;

uniform vec3 dirLight;
uniform float opacity;

// Fragment Program
void main(void)
{
	vec4 texClr = texture2D(colorMap, vTexCoord.st);

	vec4 ambientLight = vec4(0.5f, 0.5f, 0.5f, 1.0f) * texClr;

	float lightRatio = clamp(dot(-normalize(dirLight), vNrm), 0.0f, 1.0f);
	vec4 lightDirFin = lightRatio * vec4(1.0f, 1.0f, 0.8f, 1.0f) * texClr;
  
	gl_FragColor = vec4((ambientLight + lightDirFin).rgb, opacity);
}
